using System;
using System.Data;
using MethodBase = System.Reflection.MethodBase;


namespace gov.va.med.vbecs.BOL
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

	public class EnhancementMedia : BOL.BaseBusinessObject
	{
		private int _enhancementMediaID = int.MinValue;
		private string _enhancementMediaName = "";
		private System.Data.DataTable _dtEnhancementMediaList;
		/// <summary>
		/// Constant for enhancement media data columns
		/// </summary>
//		public const string ENHANCEMENTMEDIACOLUMNS = "EnhancementMediaId,LastUpdateDate,LastUpdateUser,Rowversion";
		public const string ENHANCEMENTMEDIACOLUMNS = "EnhancementMediaId";

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4127"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>EnhancementMedia object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="19"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Empty constructor
		/// </summary>
		public EnhancementMedia()
		{
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2406"> 
		///		<ExpectedInput>DataRow containing EnhancementMedia data</ExpectedInput>
		///		<ExpectedOutput>EnhancementMedia object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2441"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>Invalid EnhancementMedia object</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates EnhancementMedia object and populates it with data from DataRow
		/// </summary>
		/// <param name="dr"></param>
		public EnhancementMedia(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1132"> 
		///		<ExpectedInput>Valid enhancement media ID</ExpectedInput>
		///		<ExpectedOutput>Same number of broken rules</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2117"> 
		///		<ExpectedInput>Invalid enhancement media ID</ExpectedInput>
		///		<ExpectedOutput>One additional number of broken rules</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Enhancement Media ID
		/// </summary>
		public int EnhancementMediaId
		{
			get 
			{
				return this._enhancementMediaID;
			}
			set 
			{
				RuleBroken(MethodBase.GetCurrentMethod().Name, value == int.MinValue);
				this._enhancementMediaID = value;
			}
		}
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1133"> 
		///		<ExpectedInput>Valid enhancement media name</ExpectedInput>
		///		<ExpectedOutput>Valid enhancement media name</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="20"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// String that holds the enhancement media name
		/// </summary>
		public string EnhancementMediaName
		{
			get 
			{
				return this._enhancementMediaName;
			}
			set 
			{
				this._enhancementMediaName = value;
			}
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1134"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Gets a lookup data table of enhancement media</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="237"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets enhancement media lookup 
		/// </summary>
		/// <returns></returns>
		public System.Collections.ArrayList GetEnhancementMediaList()
		{
			this._dtEnhancementMediaList = DAL.EnhancementMedia.GetEnhancementMediaList();
			System.Collections.ArrayList al = new System.Collections.ArrayList();
			foreach(System.Data.DataRow dtRow in this._dtEnhancementMediaList.Rows)
			{				
				al.Add(dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaId].ToString() + "," + 
					dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaName].ToString());
			}
			return al;
		}
		
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7455"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7456"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetEnhancementMediaDataTable
		/// </summary>
		/// <returns>Data table</returns>
		public System.Data.DataTable GetEnhancementMediaDataTable()
		{
			return DAL.EnhancementMedia.GetEnhancementMediaList();
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if(this.VerifyMinColumnsInDataTable(ENHANCEMENTMEDIACOLUMNS.Split(','), dtRow.Table))
			{
				this.EnhancementMediaId = (int) dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaId];
				this.EnhancementMediaName = dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaName].ToString();
			}
			else
			{
				throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.GeneralError(
					Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);	
			}
		}



		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1137"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2120"> 
		///		<ExpectedInput>Invalid data row</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if(this.VerifyMinColumnsInDataTable(ENHANCEMENTMEDIACOLUMNS.Split(','), dtRow.Table))
			{
				dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaId] = this.EnhancementMediaId;
				dtRow[Common.VbecsTables.EnhancementMedia.EnhancementMediaName] = this.EnhancementMediaName;
			}
			else
			{
				throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.GeneralError(
					Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name)).ResString);	
			}
			return dtRow;
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1135"> 
		///		<ExpectedInput>string array of column names, Valid data table</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2123"> 
		///		<ExpectedInput>string array of invalid column names and invalid data table</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Checks the columns in the data table against a string array of column names
		/// </summary>
		public bool VerifyMinColumnsInDataTable(string [] colNames, System.Data.DataTable dtTable)
		{
			return Common.Utility.VerifyMinColumnsInDataTable(ENHANCEMENTMEDIACOLUMNS.Split(','), dtTable);
		}
	}
}